package kom.itbeankit.nw.ethernet;

import java.awt.*;
import java.beans.*;

import symantec.itools.awt.shape.Line;
import symantec.itools.awt.shape.HorizontalLine;
import symantec.itools.awt.shape.VerticalLine;

public class Arrow extends java.awt.Container implements EthernetInterface
{

	public Arrow()
	{
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(104,42);
		panel = new java.awt.Panel();
		panel.setLayout(null);
		panel.setBounds(0,0,104,42);
		add("Center", panel);
		arrowTimerLabel = new java.awt.Label("");
		arrowTimerLabel.setVisible(false);
		arrowTimerLabel.setBounds(8,25,18,12);
		panel.add(arrowTimerLabel);
		arrowLeftEdgeLine = new symantec.itools.awt.shape.Line();
		arrowLeftEdgeLine.setBounds(0,15,12,12);
		panel.add(arrowLeftEdgeLine);
		arrowRightEdgeLine = new symantec.itools.awt.shape.Line();
		try {
			arrowRightEdgeLine.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		arrowRightEdgeLine.setBounds(10,14,13,13);
		panel.add(arrowRightEdgeLine);
		arrowLeftVerticalLine = new symantec.itools.awt.shape.VerticalLine();
		arrowLeftVerticalLine.setBounds(5,0,1,15);
		panel.add(arrowLeftVerticalLine);
		arrowRightVerticalLine = new symantec.itools.awt.shape.VerticalLine();
		arrowRightVerticalLine.setBounds(17,0,1,15);
		panel.add(arrowRightVerticalLine);
		arrowLeftHorizontalLine = new symantec.itools.awt.shape.HorizontalLine();
		arrowLeftHorizontalLine.setBounds(0,14,5,1);
		panel.add(arrowLeftHorizontalLine);
		arrowRighthorizontalLine = new symantec.itools.awt.shape.HorizontalLine();
		arrowRighthorizontalLine.setBounds(18,14,5,1);
		panel.add(arrowRighthorizontalLine);
		arrowTopHorizontalLine = new symantec.itools.awt.shape.HorizontalLine();
		arrowTopHorizontalLine.setBounds(5,0,12,1);
		panel.add(arrowTopHorizontalLine);
		//}}
		setSize(42,42);
		//{{REGISTER_LISTENERS
		//}}
	}

	public Arrow(int number, int status){
	    this();
	    setStatus(status);
	    setNumber(number);
	}

	//{{DECLARE_CONTROLS
	java.awt.Panel panel;
	java.awt.Label arrowTimerLabel;
	symantec.itools.awt.shape.Line arrowLeftEdgeLine;
	symantec.itools.awt.shape.Line arrowRightEdgeLine;
	symantec.itools.awt.shape.VerticalLine arrowLeftVerticalLine;
	symantec.itools.awt.shape.VerticalLine arrowRightVerticalLine;
	symantec.itools.awt.shape.HorizontalLine arrowLeftHorizontalLine;
	symantec.itools.awt.shape.HorizontalLine arrowRighthorizontalLine;
	symantec.itools.awt.shape.HorizontalLine arrowTopHorizontalLine;
	//}}


	public void setStatus(int status)
	{
		if (this.status!=status)
		{
            switch(status){
                case ARROW_STATUS_OFF:
    			    turnOff();
    			    break;
    			case ARROW_STATUS_THICK_UP:
    			    turnThickUp();
    			    break;
    			case ARROW_STATUS_THICK_DOWN:
    			    turnThickDown();
    			    break;
    			case ARROW_STATUS_COUNTDOWN_UP:
    			    turnCountdownUp();
    			    break;
    			case ARROW_STATUS_COUNTDOWN_DOWN:
    			    turnCountdownDown();
    			    break;
            	default:
        	}
		}
	}
	
	public void fill(Color c){	
            arrowTimerLabel.setVisible(false);
            arrowTimerLabel.setText("");
	        Graphics g = panel.getGraphics();
	        g.setColor(c);
            switch(status){
    			case ARROW_STATUS_THICK_UP:
            	    int[] tuX = {12,15,15,26,26,28,20};
    	            int[] tuY = {13,13,39,39,13,13,4};
    	            g.fillPolygon(tuX,tuY,7);
    			    break;
    			case ARROW_STATUS_THICK_DOWN:
            	    int[] tdX = {12,20,28,26,26,15,15};
            	    int[] tdY = {32,40,32,32,7,7,32};
    	            g.fillPolygon(tdX,tdY,7);
    			    break;
            	default:
        	}
	}

	public void turnOff(){
        status=ARROW_STATUS_OFF;
        arrowTimerLabel.setText("");
        arrowTimerLabel.setVisible(false);
		showLines(false);
	}
	
	public void turnThickUp(){
	    status=ARROW_STATUS_THICK_UP;
        arrowTimerLabel.setText("");
        arrowTimerLabel.setVisible(false);
		arrowLeftEdgeLine.setBounds(10,2,12,12);
		arrowRightEdgeLine.setBounds(19,2,12,12);
		arrowLeftVerticalLine.setBounds(13,13,2,26);
		arrowRightVerticalLine.setBounds(26,13,2,26);
		arrowLeftHorizontalLine.setBounds(9,13,5,2);
		arrowRighthorizontalLine.setBounds(27,13,5,2);
		arrowTopHorizontalLine.setBounds(13,39,15,2);
        adjustEdgeLines(3, true);
		showLines(true);
	}
	public void turnThickDown(){
	    status=ARROW_STATUS_THICK_DOWN;
        arrowTimerLabel.setText("");
        arrowTimerLabel.setVisible(false);
		arrowLeftEdgeLine.setBounds(10,31,12,12);
		arrowRightEdgeLine.setBounds(19,31,12,12);
		arrowLeftVerticalLine.setBounds(13,5,2,27);
		arrowRightVerticalLine.setBounds(26,5,2,27);
		arrowLeftHorizontalLine.setBounds(9,30,5,2);
		arrowRighthorizontalLine.setBounds(27,30,5,2);
		arrowTopHorizontalLine.setBounds(13,5,13,2);
        adjustEdgeLines(3, false);
		showLines(true);
	}
	public void turnCountdownUp(){
	    status=ARROW_STATUS_COUNTDOWN_UP;
        arrowTimerLabel.setVisible(true);
	    arrowTimerLabel.setBounds(14,18,14,12);
		arrowLeftEdgeLine.setBounds(8,8,12,12);
		arrowRightEdgeLine.setBounds(20,8,13,13);
		arrowLeftVerticalLine.setBounds(11,20,1,15);
		arrowRightVerticalLine.setBounds(30,20,1,15);
		arrowLeftHorizontalLine.setBounds(9,20,2,1);
		arrowRighthorizontalLine.setBounds(30,20,3,1);
		arrowTopHorizontalLine.setBounds(11,35,19,1);
        adjustEdgeLines(1, true);
		showLines(true);
	}
	public void turnCountdownDown(){
        arrowTimerLabel.setVisible(true);
	    status=ARROW_STATUS_COUNTDOWN_DOWN;
	    arrowTimerLabel.setBounds(14,10,14,12);
		arrowLeftEdgeLine.setBounds(9,20,12,12);
		arrowRightEdgeLine.setBounds(20,19,13,13);
		arrowLeftVerticalLine.setBounds(11,5,1,15);
		arrowRightVerticalLine.setBounds(30,5,1,15);
		arrowLeftHorizontalLine.setBounds(9,19,2,1);
		arrowRighthorizontalLine.setBounds(30,19,3,1);
		arrowTopHorizontalLine.setBounds(11,5,19,1);
        adjustEdgeLines(1, false);
		showLines(true);
	}

	private void adjustEdgeLines(int thickness, boolean up){
		try {
			arrowLeftEdgeLine.setLineThickness(thickness);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			arrowRightEdgeLine.setLineThickness(thickness);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			arrowRightEdgeLine.setPositiveSlope(!up);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			arrowLeftEdgeLine.setPositiveSlope(up);
		}
		catch(java.beans.PropertyVetoException e) { }
	}

	private void showLines(boolean show){
    	arrowLeftEdgeLine.setVisible(show);
    	arrowRightEdgeLine.setVisible(show);
    	arrowLeftVerticalLine.setVisible(show);
    	arrowRightVerticalLine.setVisible(show);
    	arrowLeftHorizontalLine.setVisible(show);
    	arrowRighthorizontalLine.setVisible(show);
    	arrowTopHorizontalLine.setVisible(show);
	}


	public int getStatus()
	{
		return this.status;
	}

	public void setNumber(int number)
	{
		if (this.number != number)
		{
            this.number = number;
            String numStr = new Integer(number).toString();
            if(number < 10)
                numStr = "0" + numStr; 
            arrowTimerLabel.setText(numStr);
            repaint();
		}
	}

	public int getNumber()
	{
        return number;
	}

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(100,100);
				this.add(new Arrow());
			}
		}

		new DriverFrame().show();
	}

	protected int status = ARROW_STATUS_OFF;
    protected int number = 0;
}